<div class="content-top-1 box box-default">
    <div class="box-body">
    <div class="row">
            <div class="col-md-4">
                <div class="input-daterange input-group col-md-12" id="datepicker">
                    <input type="text" class="input-sm form-control" id="from" name="start" placeholder="From date" />
                    <span class="input-group-addon">to</span>
                    <input type="text" class="input-sm form-control" id="to" name="end" placeholder="To date" />
                </div>
            </div>
            <div class="col-md-3">
                <button class="btn btn-primary col-md-6" id="btnsearch"><i class="fa fa-search"></i></button>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-12" style="padding-left: 30px">
                <br>
                <table class="ui celled table stripe" width="100%" id="stattable">
                    <thead>
                        <th>Type</th>
                        <th>Redeeming From</th>
                        <th>Voucher Value (Kes)</th>
                        <th>Customer</th>
                        <th>Reference ID</th>
                        <th>Redeemed By.</th>
                        <th>Voucher Expiry</th>
                        <th></th>
                        <th>Added On</th>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div> 

<script type="text/javascript" src="/_public/js/mburu.js"></script>

<script type="text/javascript">
    var chart1;
    $(document).ready(function() {
        $('.input-daterange').datepicker({});
        $('#from').val(moment().subtract(1, 'months').format('MM/DD/YYYY'));
        $('#to').val(moment().endOf('month').format('MM/DD/YYYY'));

        $('#btnsearch').click(function() {
            var table = $('#stattable').DataTable({
                destroy: true,
                responsive: false,
                "ajax": {
                    url: '/tables/vouchers',
                    type: 'get',
                    data: {
                        from: $('#from').val(),
                        to: $('#to').val()
                    }
                },
                scrollY: "800px",
                scrollX: true,
                scrollCollapse: true,
                paging: true,
                fixedColumns: true,
                lengthChange: true, 
            });
            var buttons = new $.fn.dataTable.Buttons(table, {
                buttons: ['excelHtml5', 'pdfHtml5', 'colvis']
            });
            buttons.container().appendTo($('div.right.aligned.eight.column:eq(0)', table.table().container()));
        }); 
        $('#btnsearch').click();
    });
</script>