<div class="content-top-1 box box-default">
    <div class="box-body">
        <?= form_open("/clientfloat/save_float"); ?>
        <input type="hidden" name="id" id="id">
        <div class="row">
            <div class="col-md-6">
                <input type="hidden" name="cpartner" value="Client">
                Client / Partner?
                <select class="form-control" required="required" name="client" id="cid">
                    <option value="">Select Choice</option>
                </select>
                <br><br>
                Date
                <input class="form-control" required="required" name="date" id="date" placeholder="Date" type="text">
                <br>
                Loan Amount (Kes)
                <input class="form-control" required="required" name="float" id="float" step="any" placeholder="Loan amount" type="number" min="0">
            </div>
        </div>
        <br>
        <button type="submit" class="btn btn-primary">Add Loan</button>
        </form><br>
    </div>
</div>
<br>
<div class="content-top-1 box box-default">
    <div class="box-body">
        <div class="row">
            <div class="col-md-12" style="padding-left: 30px">
                <br>
                <table class="ui celled table stripe" width="100%" id="stattable">
                    <thead>
                        <th>Client</th>
                        <th>Issued On</th>
                        <th>Amount (Kes)</th>
                        <th>Issued By</th> 
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript" src="/_public/js/mburu.js"></script>

<style>
    #ttl:first-letter {
        text-transform: capitalize;
    }
</style>

<script type="text/javascript">
    var chart1;

    $(document).ready(function() {
        $('#date').datepicker({});

        $.ajax({
                url: "/clientfloat/checkclients/",
                data: {type: "Client"},
                type: "get",
                success: function(data) {
                    var json = JSON.parse(data);
                    if (json.result == "OK") {
                        for (var m = 0; m < json.message.length; m++) {
                            $('#cid').append("<option value='" + json.message[m].id + "'>" + json.message[m].name + "</option>");
                        }
                    }
                }
            });

        var table = $('#stattable').DataTable({
            destroy: true,
            responsive: false,
            "ajax": {
                url: '/clientfloat/getfloat',
                type: 'get'
            },
            select: {
                style: 'single'
            }, 
            scrollY: "800px",
            scrollX: true,
            scrollCollapse: true,
            paging: true,
            fixedColumns: true,
            lengthChange: true,
            buttons: ['excelHtml5', 'pdfHtml5', 'colvis'],
            "rowCallback": function(nRow, aData) {
                $('td', nRow).eq(2).html(parseFloat(aData[2]).toLocaleString())
                $('td', nRow).eq(8).html("<a href='<?= APP_BASE; ?>float_history/" + encodeURIComponent(btoa(aData[2])) + "' class='btn btn-sm btn-default'> View History </a>");
            },
            "footerCallback": function(row, data, start, end, display) {}
        });

        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: ['excelHtml5', 'pdfHtml5', 'colvis']
        });
        buttons.container().appendTo($('div.right.aligned.eight.column:eq(0)', table.table().container()));
    });
</script>