<br>
<div class="content-top-1 box box-default">
    <br>
    <div class="box-body">
        <?= form_open("/redemption/redeem"); ?>
        <div class="row">
            <div class="col-md-6">
                Voucher To
                <input class="form-control" required="required" name="contact_phone" id="contact_phone" pattern="^(0)([0-9]{9})$" title="Phone number should start with: 0xxxxxxxxx" placeholder="Phone number (0xxxxxxxxx)" autocomplete="off" type="text">
                <br>
                Customer
                <select class="form-control" required="required" name="customer" id="customer">
                    <option value="">Select Customer</option>
                </select>
                <br><br>
                Redeem From
                <select class="form-control" required="required" name="dmo_id" id="partner">
                    <option value="">Redeem From</option>
                </select>
                <br><br>
                Amount (Kes)
                <input class="form-control" required="required" name="amount" id="amount" step="any" placeholder="Redeem amount (0 if discount)" type="number">

                <div id="kplc">
                    <br>
                    Meter / Account No.
                    <input class="form-control" required="required" name="account" id="account" step="any" placeholder="KPLC meter / account number" type="number">
                </div>

                <div id="airtime">
                    <br>
                    Operator
                    <select class="form-control" required="required" name="operator" id="operator">
                        <option value="">Select Operator</option>
                        <option value="safaricom">Safaricom</option>
                        <option value="airtel">Airtel</option>
                        <option value="orange">Orange</option>
                    </select>
                    <br><br>
                </div>

            </div>
        </div>
        <br>
        <button type="submit" class="btn btn-info">Generate Voucher</button>
        </form><br>
    </div>
</div>
<br>
<script language="javascript">
    $(document).ready(function() {
        $('#kplc,#airtime').fadeOut();

        $('#kplc input,#kplc select').removeAttr('required');
        $('#airtime input,#airtime select').removeAttr('required');

        $.ajax({
            url: "/redemption/fetchCustomers",
            type: "get",
            success: function(data) {
                var json = JSON.parse(data);
                if (json.result == "ok") {
                    for (var m = 0; m < json.data.length; m++) {
                        $('#customer').append("<option value='" + json.data[m].client_id + "'>" + json.data[m].name + "</option>");
                    }
                }
            }
        });

        $('#customer').change(function() {
            var cust = this.value;
            $.ajax({
                url: "/redemption/fetchPartners",
                type: "get",
                data: {
                    client_id: cust
                },
                success: function(data) {
                    var json = JSON.parse(data);
                    $('#partner option').not(':first').remove();
                    $('#partner').val("").change();
                    if (json.result == "ok") {
                        for (var m = 0; m < json.data.length; m++) {
                            $('#partner').append("<option value='" + json.data[m].dmo_id + "'>" + json.data[m].name + " - " + json.data[m].type + "</option>");
                        }
                    }
                }
            });
        })

        $('#partner').change(function() {
            var dmo_id = this.value;
            if (dmo_id == "vend_airtime") {
                $('#airtime').fadeIn();
                $('#airtime input,#airtime select').attr('required', 'required');
            } else {
                $('#airtime').fadeOut();
                $('#airtime input,#airtime select').removeAttr('required');
            }

            if (dmo_id == "kplc_tokens" || dmo_id == "kplc_postpay") {
                $('#kplc').fadeIn();
                $('#kplc input,#kplc select').attr('required', 'required');
            } else {
                $('#kplc').fadeOut();
                $('#kplc input,#kplc select').removeAttr('required');
            }

        })
    });
</script>