<br>
<div class="content-top-1 box box-default">
    <div class="box-body">
        <div class="row">
            <div class="col-md-12">
                <br>
                <div class="status"></div>
                <div class="progress">
                    <div class="progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100"> </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-2">
                <?= form_open_multipart("/crossindustry/init_egift"); ?>   
                <button type="submit" class="btn btn-success" style="margin-top: 10px;"><i class="fa fa-gift"></i>Pull e-gift partners</button>
                </form>
            </div>
        </div>
        
    </div>
</div>  

<script>
    var es;

    function startTask() {
        es = new EventSource('<?= base_url(); ?>crossindustry/notifyclient'); 
        //a message is received
        es.addEventListener('message', function(e) {
            var result = JSON.parse(e.data);
            if (e.lastEventId == 'CLOSE') {
                es.close();
            } else {
                $(".progress-bar").attr("aria-valuenow", result.percent)
                $(".progress-bar").css("width", result.percent + "%")
                $(".progress-bar").html(result.percent + "% Complete " + (result.percent == 100 ? "(Success)" : "(Processing...)"));

                $(".progress-bar").removeClass("progress-bar-success");
                $(".progress-bar").removeClass("progress-bar-warning");
                $(".progress-bar").removeClass("progress-bar-info");
                $(".progress-bar").removeClass("progress-bar-danger");

                $(".status").html("Task: " + result.task + "  Current :" + result.status);

                if (parseFloat(result.percent) < 25)
                    $(".progress-bar").addClass("progress-bar-danger")
                else if (result.percent < 50)
                    $(".progress-bar").addClass("progress-bar-warning")
                else if (result.percent < 75)
                    $(".progress-bar").addClass("progress-bar-info")
                else if (result.percent == 100) {
                    $(".progress-bar").addClass("progress-bar-success")
                    $(".progress-bar").removeClass("progress-bar-striped");
                    $(".progress-bar").removeClass("progress-bar-animated");
                }
            }
        });

        es.addEventListener('error', function(e) {
            switch (e.target.readyState) {
                case EventSource.CONNECTING:
                    msg = 'Reconnecting…';
                    break;
                    // if error was fatal
                case EventSource.CLOSED:
                    msg = 'Connection failed. Will not retry.';
                    es.close();
                    break;
            }
        })
    }

    $(document).ready(function() {    
        startTask();
    });
</script>