﻿<div class="content-top-1 box box-default">
    <div class="box-body">
        <div class="row">
            <div class="col-lg-4">
                <div class="info-box bg-green-active">
                    <span class="info-box-icon"><i class="fa fa-user"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Customers</span>
                        <br>
                        <span class="info-box-number" id="customers">0</span>
                    </div>
                </div>
            </div>
 
            <div class="col-lg-3">
                <div class="info-box bg-navy">
                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Customer Outstanding Balance</span>
                        <br>
                        <span class="info-box-number" id="float">0</span>
                    </div>
                </div>
            </div> 
        </div>

    </div>
</div> 
<br>
<div class="row">
    <div class="col-md-12"> 
        <div class="content-top-1 box box-default">
            <div class="box-body">
                <h4>Customer Outstanding Balance</h4><br>
                <table class="ui celled table stripe" width="100%" id="customerfloat">
                    <thead>
                        <th>Customer</th>
                        <th>Loan Amount (Kes)</th>
                        <th>Paid (Kes)</th>
                        <th>Outstanding Balance (Kes)</th>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript" src="/_public/js/mburu.js"></script>
<script type="text/javascript">
    var chartdata = {
        labels: [],
        datasets: []
    };

    $(document).ready(function() {
        var customercount = 0;
        var vendorcount = 0;
        var vendorfloat = 0;
        var customerfloat = 0;

        
        var table2 = $('#customerfloat').DataTable({
            destroy: true,
            responsive: false,
            "ajax": {
                url: '/tables/customerfloat',
                type: 'get'
            },
            scrollY: "800px",
            scrollX: true,
            scrollCollapse: true,
            paging: true,
            fixedColumns: true,
            lengthChange: true,
            "rowCallback": function(nRow, aData) {
                customerfloat += parseFloat(aData[3]);
                $('#float').html("Kes " + customerfloat.toLocaleString());

                $('td', nRow).eq(1).html(parseFloat(aData[1]).toLocaleString())
                $('td', nRow).eq(2).html(parseFloat(aData[2]).toLocaleString())
                $('td', nRow).eq(3).html(parseFloat(aData[3]).toLocaleString())
            },
            "footerCallback": function(row, data, start, end, display) { 
                $("#customers").html(data.length.toLocaleString())
            }
        });

        var buttons = new $.fn.dataTable.Buttons(table2, {
            buttons: ['excelHtml5', 'pdfHtml5']
        });
        buttons.container().appendTo($('div.right.aligned.eight.column:eq(0)', table2.table().container()));
    })
</script>