<div class="content-top-1 box box-default">
    <div class="box-header">
        <div class="box-tools pull-right">
            <div class="row" style="margin-right: 10px">

                <?php
                if ($this->session->userdata('role') == "Admin" || $this->session->userdata('role') == "Tech") {
                ?>
                    <a href="javascript:void(0);" id="assign" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Assign to Client </a> &nbsp; &nbsp; &nbsp;

                    <a href="javascript:void(0);" id="disable" class="btn btn-danger btn-sm"><i class="fa fa-ban"></i> Suspend </a> &nbsp; &nbsp; &nbsp;

                    <a href="javascript:void(0);" id="restore" class="btn btn-success btn-sm"><i class="fa fa-tick"></i> Restore </a> &nbsp; &nbsp; &nbsp;

                <?php
                }
                ?>   
            </div>
        </div>
    </div>
    <br>
    <div class="box-body">
        <div class="row">
            <div class="col-md-12">
                <table id="usersTable" class="ui celled table stripe" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Type</th>
                            <th>Country</th>
                            <th>Redemption Units</th>
                            <th>Clients Subscribed</th>
                            <th>Logo</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <br>
        <label class="label label-info" id="wait"></label>

    </div>
</div>

<a  data-target="#usersmodal" data-toggle="modal" id="showpopup"></a>

<div id="usersmodal" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title">Cross Industry Partners</h4>
            </div> 
            <?= form_open("/crossindustry/assign_partners",array('id'=>'cross')); ?>
            <div class="modal-body">
                Client To Assign
                <br>
                <select class="form-control" required="required" style="width: 100%;" name="client" id="cid">
                    <option value="">Select Client</option> 
                </select> 
                <br>
            </div> 
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary ">Assign Redemption Partner</button>
            </div>
            </form>
        </div>
    </div>
</div>

<div style="position: absolute; left:-999999999999; top: -999999999; visibility: hidden">
    <?= form_open("/crossindustry/disable_partner", array('id' => 'dfrm')) ?>
    <button type="submit" id="dsubmit"></button>
    </form>

    <?= form_open("/crossindustry/enable_partner", array('id' => 'efrm')) ?>
    <button type="submit" id="esubmit"></button>
    </form>
</div> 
<script type="text/javascript">
    var table;

    function loadTable() {
        table = $('#usersTable').DataTable({
            destroy: true,
            responsive: false,
            "ajax": {
                url: '/tables/crossindustry',
                type: 'get'
            },
            select: {
                style: 'multi',
                selector: 'td'
            },
            "order": [
                [0, "asc"]
            ],
            columnDefs: [{
                width: 80,
                targets: 6
            }],
            fixedColumns: false,
            scrollY: "800px",
            scrollX: true,
            scrollCollapse: true,
            paging: true,
            lengthChange: true,
            "rowCallback": function(nRow, aData) {

                
                if(aData[6]!=null && aData[6]!="undefined" ){
                    var images = aData[6].split(",");
                    $('td', nRow).eq(6).html('<img src="' + images[0] + '" style="height: 70px; width: 70px">');
                }

                if (aData[7] == 0)
                    $('td', nRow).eq(7).html('<label class="label label-success">Active</label>');
                else
                    $('td', nRow).eq(7).html('<label class="label label-danger">Suspended</label>');
            }
        });

    }

    $(document).ready(function() { 
        $.ajax({
            url: "/clientfloat/checkclients",
            type: "get",
            data:  {type: 'client'},
            success: function(data) {
                var json = JSON.parse(data);
                if (json.result == "OK") {
                    for (var m = 0; m < json.message.length; m++) { 
                        $('#cid').append("<option value='" + json.message[m].id + "'>" + json.message[m].name + "</option>");
                    }
                }
            }
        });
        
        $('#assign').click(function() {
            if (table.rows('.selected').data().length > 0) { 
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data();
                for (var i = 0; i < len; i++) {
                    var row = table.rows('.selected').data()[i];
                    $('#cross').append("<input type='hidden' name='code[]' value='" + row[8] + "'>");
                }
                $('#showpopup').click();
            } else
                alert("please select a partner");
        });

        $('#disable').click(function() {
            if (table.rows('.selected').data().length > 0) { 
                $('#dfrm input').remove();
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data();
                for (var i = 0; i < len; i++) {
                    var row = table.rows('.selected').data()[i]; 
                    $('#dfrm').append("<input type='hidden' name='code[]' value='" + row[8] + "'>");
                }
                $('#dsubmit').click();
            } else
                alert("please select a partner");
        });

        $('#restore').click(function() {
            if (table.rows('.selected').data().length > 0) { 
                $('#efrm input').remove();
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data();
                for (var i = 0; i < len; i++) {
                    var row = table.rows('.selected').data()[i]; 
                    $('#efrm').append("<input type='hidden' name='code[]' value='" + row[8] + "'>");
                }
                $('#esubmit').click();
            } else
                alert("please select a partner");
        }); 

        loadTable()

    });
</script>