
<div class="content-top-1 box box-default">
    <div class="box-header">
        <br>
        <?php
        $role = $this->session->userdata('role');
        if (strtolower($role) == "admin") {
        ?>
            <div class="box-tools pull-left" style="padding-right: 30px"> 
                <a href="javascript:void(0);" id="edit" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i> Edit</a> 
            </div>
        <?php
        }
        ?>
    </div>
    <div class="box-body">
        <br>
        <table id="usersTable" class="ui celled table stripe" cellspacing="0" width="100%">
            <thead> 
                <tr>
                    <th>Client</th>
                    <th>System Url</th>
                    <th>Client Phone</th>
                    <th>Account Manager</th>
                    <th>Technical Person</th>
                    <th>Added By</th>
                    <th>Added On</th>
                    <th>Contact</th>
                    <th>Contact Phone</th>
                    <th>CrossIndustry</th>
                    <th>Discounts</th>
                    <th>Cashback</th>
                    <th>Local Redemption</th>
                </tr>
            </thead>
        </table>
    </div>
</div> 

<script type="text/javascript">
    var table;
    $(document).ready(function() {  
        table = $('#usersTable').DataTable({
            destroy: true,
            responsive: false,
            "ajax": {
                url: '/customers/getClients',
                type: 'get'
            },
            select: {
                style: 'single',
                selector: 'td'
            },
            "order": [
                [4, "desc"]
            ], 
            scrollY: "800px",
            scrollX: true,
            scrollCollapse: true,
            paging: true,
            fixedColumns: false,
            lengthChange: true,
            buttons: ['excelHtml5', 'pdfHtml5', 'colvis', 'selectAll', 'selectNone'],
            "rowCallback": function(nRow, aData) {
                for(var i=9; i<13; i++){
                    if(aData[i]==1)
                        $('td', nRow).eq(i).html('<label class="label label-success">Yes</label>');
                    else
                        $('td', nRow).eq(i).html('<label class="label label-default">No</label>');
                } 
            }

        });

        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: ['excelHtml5', 'pdfHtml5', 'colvis']
        });
        buttons.container().appendTo($('div.right.aligned.eight.column:eq(0)', table.table().container()));

        $('#edit').click(function() {
            if (table.rows('.selected').data().length > 0) { 
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data()[0]; 
                window.location.href = "<?= APP_BASE; ?>client/" + encodeURIComponent(btoa(items[15]));
            } else
                alert("please select a client to edit.");
        }); 
    });
</script>