<div class="content-top-1 box box-default">
    <div class="box-header">
        <br>
        <?php
        $role = $this->session->userdata('role');
        if (strtolower($role) == "admin") {
        ?>
            <div class="box-tools pull-left" style="padding-right: 30px">
                <a href="javascript:void(0);" id="send" class="btn btn-primary btn-sm"><i class="fa fa-envelope"></i> Resend Credentials</a>
                <a href="javascript:void(0);" id="regen" class="btn btn-danger btn-sm"><i class="fa fa-refresh"></i> Regenerate</a>
            </div>
        <?php
        }
        ?>
    </div>
    <div class="box-body">
        <br>
        <table id="usersTable" class="ui celled table stripe" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>Client</th>
                    <th>System Url</th>
                    <th>Client Phone</th>
                    <th>Account Manager</th>
                    <th>Technical Person</th>
                </tr>
            </thead>
        </table>
    </div>
</div>


<div style="visibility: hidden; position: absolute">
    <?= form_open("/customers/regenerate", array('id' => 'frm')); ?>
    <button type="submit" id="msubmit"></button>
    </form>
</div>

<script type="text/javascript">
    var table;
    $(document).ready(function() {
        table = $('#usersTable').DataTable({
            destroy: true,
            responsive: false,
            "ajax": {
                url: '/customers/getClients',
                type: 'get'
            },
            select: {
                style: 'single',
                selector: 'td'
            },
            "order": [
                [4, "desc"]
            ],
            scrollY: "800px",
            scrollX: true,
            scrollCollapse: true,
            paging: true,
            fixedColumns: false,
            lengthChange: true,
            buttons: ['excelHtml5', 'pdfHtml5', 'colvis', 'selectAll', 'selectNone'],
            "rowCallback": function(nRow, aData) {
                for (var i = 9; i < 13; i++) {
                    if (aData[i] == 1)
                        $('td', nRow).eq(i).html('<label class="label label-success">Yes</label>');
                    else
                        $('td', nRow).eq(i).html('<label class="label label-default">No</label>');
                }
            }

        });

        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: ['excelHtml5', 'pdfHtml5', 'colvis']
        });
        buttons.container().appendTo($('div.right.aligned.eight.column:eq(0)', table.table().container()));

        $('#send').click(function() {
            if (table.rows('.selected').data().length > 0) {
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data()[0];

                $('#frm input').remove();
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data();

                $('#frm').append("<input type='text' name='cid' value='" + items[0][15] + "'>");
                $('#frm').append("<input type='text' name='action' value=''>");
                $('#msubmit').click();
            } else
                alert("please select a client.");
        });

        $('#regen').click(function() {
            if (table.rows('.selected').data().length > 0) {
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data()[0];

                $('#frm input').remove();
                var len = table.rows('.selected').data().length;
                var items = table.rows('.selected').data();

                $('#frm').append("<input type='text' name='cid' value='" + items[0][15] + "'>");
                $('#frm').append("<input type='text' name='action' value='regen'>");
                $('#msubmit').click();

            } else
                alert("please select a client.");
        });
    });
</script>