<?php
defined('BASEPATH') or exit('Sorry request could not be completed');
class Vendingpoint
{
    protected $ci;
    public $im;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('auditmodel');
        $this->ci->load->model('apimodel');
        $this->ci->load->model('vouchersmodel');
    }

     function execute($url, $data)
    {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

     function buy_credit($credit, $mobile, $operator)
    {
        $url = 'https://vendingpointea.com:2053/v3/login';
        $data = array('username' => VENDING_USERNAME, 'password' => VENDING_PASSWORD);
        $response = $this->execute($url, $data);

        if ($response === false)
            return json_encode(array('result' => 'fail', 'refcode' => '', 'refid' => '', 'msg' => "Failed to make request", 'raw' => $response));
        else {
            $obj = json_decode($response);  
            if ($obj->status == 0) {
                if (($obj->balance / 100) >  5 && ($obj->balance / 100) >  $credit) {
                    $url = 'https://vendingpointea.com:2053/v3/airtimebuypinless';
                    $data = array("username" => VENDING_USERNAME, "operator" => $operator, "amount" => $credit, "mobileno" => "$mobile", "key" => $obj->key);
                    $response = $this->execute($url, $data);

                    $obj = json_decode($response);
                    $b = $obj->transaction;
                    if ($b->status == 1) {
                        return json_encode(array('result' => 'ok', 'refcode' => $b->receiptno, 'refid' => $b->transactionId, 'raw' => $response));
                    } else {
                        return json_encode(array('result' => 'fail', 'refcode' => '', 'refid' => '', 'msg' => $b->msg, 'raw' => $response));
                    }
                } else {
                    $this->ci->auditmodel->insert("Vending point Low  Account Balance " . ($obj->balance / 100), 1, "Service", $response);
                    return json_encode(array('result' => 'fail', 'refcode' => '', 'refid' => '', 'msg' => "Low account balance", 'raw' => $response));
                }
            } else
                return json_encode(array('result' => 'fail', 'refcode' => '', 'refid' => '', 'msg' => $obj->msg, 'raw' => $response));
        }
    }

     function kplc_bill($account, $amount, $mobile)
    {
        $url = 'https://vendingpointea.com:2053/v3/login';
        $data = array('username' => 'mzawadi', 'password' => VENDING_PASSWORD);
        $response = $this->execute($url, $data);
        // $obj = json_decode($response);

        if ($response === false)
            return json_encode(array('result' => 'fail', 'token' => '', 'refid' => '', 'msg' => "Failed to make request", 'raw' => $response));
        else {
            $obj = json_decode($response);

            if ($obj->status == 0) {
                $key = $obj->key;
                if (($obj->balance / 100) >  $amount) {
                    $url = 'https://vendingpointea.com:2053/v3/verify';
                    $data = array("username" => VENDING_USERNAME, "meter" => "$account", "key" => $key);
                    $response = $this->execute($url, $data);

                    $obj = json_decode($response);
                    //do pay now
                    if ($obj->status == 0) {
                        $customer = $obj->customerName;

                        $url = 'https://vendingpointea.com:2053/v3/vend';
                        $data = array("username" => VENDING_USERNAME, "meter" => "$account", "amount" => $amount, "key" => $key, "customerName" => $customer);
                        $response = $this->execute($url, $data);

                        $obj = json_decode($response);
                        if ($obj->status == 1) {
                            $msg = $obj->msg;
                            if (empty($msg)) {
                                $o = $obj->transaction;
                                $ref = $o->transactionId;
                                return json_encode(array('result' => 'ok', 'customer' => $customer, 'token' => '', 'refid' => $ref, 'units' => '', 'msg' => $o->msg, 'raw' => $response));
                            } else
                                return json_encode(array('result' => 'fail', 'customer' => $customer, 'token' => '', 'refid' => '', 'units' => '', 'msg' => $obj->transaction->msg, 'raw' => $response));
                        } else {
                            $o = $obj->transaction;
                            $token = $o->token;
                            $units = $o->units;
                            $ref = $o->ref;

                            return json_encode(array('result' => 'ok', 'customer' => $customer, 'token' => $token, 'refid' => $ref, 'units' => $units, 'raw' => $response));
                        }
                    } else
                        return json_encode(array('result' => 'fail', 'customer' => '', 'token' => '', 'refid' => '', 'units' => '', 'msg' => $obj->msg, 'raw' => $response));
                } else {
                    $this->ci->auditmodel->insert("Vending point Low  Account Balance " . ($obj->balance / 100), 1, "Service", $response);
                    return json_encode(array('result' => 'fail', 'customer' => '', 'token' => '', 'refid' => '', 'units' => '', 'msg' => "Low account balance", 'raw' => $response));
                }
            } else
                return json_encode(array('result' => 'fail', 'customer' => '', 'token' => '', 'refid' => '', 'units' => '', 'msg' => $obj->msg, 'raw' => $response));
        }
    }

     function kplc_bill_only($account, $amount, $mobile)
    {
        $url = 'https://vendingpointea.com:2053/v3/login';
        $data = array('username' => VENDING_USERNAME, 'password' => VENDING_PASSWORD);
        $response = $this->execute($url, $data);
        $obj = json_decode($response);

        if ($response === false)
            return json_encode(array('result' => 'fail', 'rctnum' => '', 'refid' => '', 'msg' => "Failed to make request", 'raw' => $response));
        else {
            if ($obj->status == 0) {
                $key = $obj->key;
                if (($obj->balance / 100) >  $amount) {
                    $url = 'https://vendingpointea.com:2053/v3/postpaidverify';
                    $data = array("username" => VENDING_USERNAME, "accountNo" => "$account", "key" => $key);
                    $response = $this->execute($url, $data);
                    $obj = json_decode($response);

                    //do pay now 
                    if ($obj->status == 0) {
                        $customer = $obj->customerName;

                        $url = 'https://vendingpointea.com:2053/v3/postpaidbill';
                        $data = array("username" => VENDING_USERNAME, "accountNo" => "$account", "amount" => $amount, "key" => $key, "customerName" => $customer);
                        $response = $this->execute($url, $data);
                        $obj = json_decode($response);

                        if ($obj->status == 1) {
                            $msg = $obj->msg;
                            if (empty($msg)) {
                                $o = $obj->transaction;
                                $ref = $o->transactionId;
                                return json_encode(array('result' => 'ok', 'customer' => $customer, 'rctnum' => '', 'refid' => $ref, 'msg' => $o->msg, 'raw' => $response));
                            } else
                                return json_encode(array('result' => 'fail', 'customer' => $customer, 'rctnum' => '', 'refid' => '', 'msg' => $obj->transaction->msg, 'raw' => $response));
                        } else {
                            $o = $obj->transaction;
                            $ref = $o->ref;
                            $rcpt = $o->rctNum;

                            return json_encode(array('result' => 'ok', 'customer' => $customer, 'rctnum' => $rcpt, 'refid' => $ref, 'msg' => '', 'raw' => $response));
                        }
                    } else
                        return json_encode(array('result' => 'fail', 'customer' => '', 'rctnum' => '', 'refid' => '', 'msg' => $obj->msg, 'raw' => $response));
                } else {
                    $this->ci->auditmodel->insert("Vending point Low  Account Balance " . ($obj->balance / 100), 1, "Service", $response);
                    return json_encode(array('result' => 'fail', 'customer' => '', 'rctnum' => '', 'refid' => '', 'msg' => "Low account balance", 'raw' => $response));
                }
            } else
                return json_encode(array('result' => 'fail', 'rctnum' => '', 'refid' => '', 'msg' => $obj->msg, 'raw' => $response));
        }
    }
}
