<?php
defined('BASEPATH') or exit('Sorry request could not be completed');
require APPPATH . 'libraries/REST_Controller.php';
class Redemption_api extends REST_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('auditmodel');
        $this->load->model('msgmodel');
        $this->load->model('cmerchantmodel');
        $this->load->model('cunitsmodel');
        $this->load->model('dbmodel');
        $this->load->model('vouchersmodel');
        $this->load->model('tokenmodel');
        $this->load->library('form_validation');
        $this->load->helper('string');
        $this->load->library('vendingpoint');
        $this->load->library('egift');
    }

    function getAuthorizationHeader()
    {
        $headers = null;
        if (isset($_SERVER['Authorization'])) {
            $headers = trim($_SERVER["Authorization"]);
        } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
            $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
            if (isset($requestHeaders['Authorization'])) {
                $headers = trim($requestHeaders['Authorization']);
            }
        }
        return $headers;
    }

    function getBearerToken()
    {
        $headers = $this->getAuthorizationHeader();
        if (!empty($headers)) {
            if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
                return $matches[1];
            }
        }
        return null;
    }

    private function checkToken($request_client_id)
    {
        $autho = $this->getBearerToken();
        if (!empty($autho)) {
            //base 64 encode id:secret:key
            $token = base64_decode($autho);
            $array = explode(":", $token);
            $id = $array[0];
            $secret = $array[1];
            $key = $array[2];

            $customer = $this->dbmodel->get('customers', array('record_state' => 0, 'client_extid' => $id, 'consumer_secret' => $secret, 'consumer_key' => $key));
            if ($request_client_id == $id && $customer->num_rows() > 0)
                return array('result' => 'ok', 'data' => $customer->row()->id);
            else
                return array('result' => 'fail', 'data' => 'Invalid token');
        } else
            return array('result' => 'fail', 'data' => 'Invalid token');
    }

    private function unauthorized($message, $optional = 200)
    {

        $this->response(array('result' => 'fail', 'data' => $message));
    }

    // function test_get(){
    //     echo base64_encode("4d483da664e8ce74c368a062d13b5d3bca599967:MBrRPbDsXW8OZUgpC3qi:C4xZtUn8ad");
    // }

    function get_redeemables_post()
    {
        $client_id = $this->post('client_id');
        $resp = $this->checkToken($client_id);
        if ($resp['result'] == "ok") {
            $id = $resp['data'];
            $merchants = array();

            $customer = $this->dbmodel->get('redemption_mappings', array('record_state' => 0, 'client_id' => $id));

            foreach ($customer->result_array() as $cust) {
                $partners = $this->cmerchantmodel->get(array('record_state' => 0, 'dmo_id' => $cust['dmo_id']));
                foreach ($partners->result_array() as $row) {
                    $u = array();
                    $units = $this->cunitsmodel->get(array('dmo_id' => $row['dmo_id']));
                    foreach ($units->result_array() as $unit) {
                        $u[] = array(
                            'type' => $unit['type'],
                            'unit' => $unit['unit'],
                            'min' => $unit['min'],
                            'max' => $unit['max'],
                            'step' => $unit['step'],
                            'value' => $unit['value']
                        );
                    }

                    $merchants[] = array(
                        'dmo_id'  => $row['dmo_id'],
                        'type'  => $row['type'],
                        'name'  => $row['name'],
                        'termsconditions'  => $row['termsconditions'],
                        'description'  => $row['description'],
                        'categories'  => $row['categories'],
                        'images'  => $row['images'],
                        'country'  => $row['country'],
                        'unit' => $u
                    );
                }
            }

            $this->response(array('result' => 'ok', 'data' => $merchants));
        } else
            $this->unauthorized("Invalid Token");
    }

    function get_float_post()
    {
        $client_id = $this->post('client_id');
        $resp = $this->checkToken($client_id);
        if ($resp['result'] == "ok") {
            $id = $resp['data'];

            $status = $this->post('status');
            $history = array();
            $floatbal = 0;
            $floats = $this->dbmodel->get('client_float_balance', array('client_extid' => $client_id));
            $floathistories = $this->dbmodel->get('client_float', array('client_id' => $id, 'type' => 'client', 'record_state' => 0));
            foreach ($floathistories->result_array() as $row) {
                $history[] = array(
                    'amount' => $row['client_float'],
                    'toppedon' => $row['topped_on']
                );
            }

            $floatbal = $floats->num_rows() > 0 ? $floats->row()->balance : 0;

            if (!empty($status)) {
                $this->dbmodel->update('customers', array('status' => $status, 'status_date' => date('Y-m-d H:i:s')), array('id' => $id));
            }

            $this->response(array('result' => 'ok', 'data' => array('total' => $floatbal, 'history' => $history)));
        } else
            $this->unauthorized("Invalid Token");
    }

    function buy_card_post()
    {
        $client_id = $this->post('client_id');
        $resp = $this->checkToken($client_id);
        if ($resp['result'] == "ok") {
            $id = $resp['data'];

            $dmo_id = $this->post('dmo_id');
            $phone_no = $this->post('phone_no');

            $partners = $this->cmerchantmodel->get(array('record_state' => 0, 'dmo_id' => $dmo_id));


            if (empty($dmo_id) || $partners->num_rows() == 0) {
                $this->auditmodel->insert("Tried to redeem. Api called without a valid dmo_id ", 0, "Redemption API", json_encode($this->post()));
                $this->unauthorized("Select a redemption point");
                return;
            }

            if (empty($phone_no) || !preg_match('/^(0)([0-9]{9})$/', $phone_no)) {
                $this->auditmodel->insert("Tried to redeem. Api called without a valid phone number ", 0, "Redemption API", json_encode($this->post()));
                $this->unauthorized("Supply phone number.");
                return;
            }

            $partner = $partners->row();
            $amount = $this->post('amount');

            if ((strtolower($partner->type) == "discount" || strtolower($partner->type) == "redemption & discount") && empty($amount)) {
                //generate discount code.
                $this->auditmodel->insert("Requested a discount code for " . $partner->name . " phone number " . $phone_no, 1, "Redemption API", json_encode($this->post()));

                $units = $this->cunitsmodel->get(array('dmo_id' => $dmo_id, 'type' => 'discount'));
                if ($units->num_rows() == 0) {
                    $this->auditmodel->insert("Tried to get discout code for phone no: " . $phone_no . ". Partner requested does not have redemption options. ", 0, "Redemption API", json_encode($this->post()));
                    $this->unauthorized("Invalid discount partner selected.");
                    return;
                }

                $unit = $units->row();

                $discount_type = $unit->unit == "fixed" ?  "kes" : "%";
                $discount_amount = $unit->value;

                $vndors = $this->dbmodel->get('local_partners', array('partner' => $partner->merchantcode));
                if ($vndors->num_rows() > 0) {
                    $r = $vndors->row();
                    if (empty($r->discount_code))
                        $voucher_code = $this->generatevoucher();
                    else
                        $voucher_code = $r->discount_code;
                } else
                    $voucher_code = $this->generatevoucher();


                $refid = $this->generaterefid();
                $value = $unit->unit == "fixed" ?  "kes " . $unit->value : $unit->value . "%";

                $data = array(
                    'verified' => 1,
                    'record_state' => 0,
                    'voucher_type' => 'Discount',
                    'dmo_id' => $dmo_id,
                    'CUST_CODE' => '',
                    'voucher_value' => 0,
                    'addedon' => date('Y-m-d H:i:s'),
                    'verifiedon' => date('Y-m-d H:i:s'),
                    'raw' => $value,
                    'client_id' => $client_id,
                    'ref_id' => $refid,
                    'noofpoints' => 0,
                    'expiry' => date('Y-m-d H:i:s', strtotime('+6 months')),
                    'CUST_NAME' => '',
                    'CUST_PHONE' => $phone_no,
                    'voucher_code' => $voucher_code
                );

                $rec = $this->vouchersmodel->insert($data);

                if ($rec > 0) {
                    $this->auditmodel->insert("Discount code for " . $value . " in " . $partner->name . " issued to phone no: " . $phone_no . " successful. Discount code: " . $voucher_code, 1, "Redemption API", json_encode($this->post()));
                    $this->response(array('result' => 'ok', 'data' => array('voucher_code' => $voucher_code, 'expiry' => $data['expiry'], 'unit' => $discount_type, 'amount' => $discount_amount)));
                } else {
                    $this->auditmodel->insert("Discount code for " . $value . " in " . $partner->name . " issued to phone no: " . $phone_no . " successful. Discount code: " . $voucher_code, 1, "Redemption API", json_encode($this->post()));
                    $this->unauthorized("Failed to generate discount code. Please try again.");
                }
            } else {

                $units = $this->cunitsmodel->get("dmo_id='$dmo_id' and ((value=$amount and type like 'fixed') or (type like 'variable' and  min<=$amount and max>=$amount) )");

                $this->auditmodel->insert("Requested a redemption for " . $partner->name . " for amount " . $amount, 1, "Redemption API", json_encode($this->post()));

                if (empty($amount) && $amount == 0 && $units->num_rows() == 0) {
                    $this->auditmodel->insert("Failed to validate redemption amount for " . $partner->name . " for amount " . $amount . " Invalid redemption amount", 0, "Redemption API", json_encode($this->post()));
                    $this->unauthorized("Enter redemption amount");
                    return;
                }

                //check float
                $floats = $this->dbmodel->get('client_float_balance', array('client_extid' => $client_id));
                $partnerfloats = $this->dbmodel->get('partner_float_balance', array('name' => $partner->merchantcode));

                if ($floats->num_rows() == 0 || $partnerfloats->num_rows() == 0) {
                    $this->auditmodel->insert("Failed to validate redemption amount for " . $partner->name . " for amount " . $amount . " Float data not available", 0, "Redemption API", json_encode($this->post()));
                    $this->unauthorized("Failed to redeem. please try again.");
                    die();
                }

                $float = $floats->row();
                $pfloat = $partnerfloats->row();

                // || $pfloat->balance < $amount 

                if ($float->balance < $amount) {
                    $this->auditmodel->insert("Failed to validate redemption amount for " . $partner->name . " for amount " . number_format($amount) . " Float available is less than redemption amount", 0, "Redemption API", json_encode($this->post()));
                    $msg = '<p>' . ucfirst($partner->name) . ' float needs to be replenished.</p> 
						<br>A client need to redeem kes ' . number_format($amount) . ' yet available float is kes' . number_format($float->balance) . " Vendor float kes: " . number_format($pfloat->balance);
                    if (!empty(MAIL_ALERT))
                        $this->msgmodel->insert_comm(MAIL_ALERT, "email", $msg, APP_NAME . ", Low float balance", 'Support', "System");
                    $this->msgmodel->insert_comm("vbnetter@gmail.com", "email", $msg, APP_NAME . ", Low float balance", 'Support', "System");
                    $this->unauthorized("Failed to redeem. please try again.");
                    return;
                }

                if (($float->balance  - $amount) <= 5000 || ($pfloat->balance  - $amount) <= 5000) {
                    $this->auditmodel->insert("Float for " . $partner->merchantcode . " is running low current float kes " . number_format($float->balance  - $amount) . " vendor float kes " . ($pfloat->balance - $amount), 0, "Redemption API", json_encode($this->post()));
                    $msg = '<p>' . ucfirst($partner->merchantcode) . ' float needs to be replenished.</p> 
						<br>Remaining balance kes ' . number_format($float->balance  - $amount) . "  vendor float kes " . number_format($pfloat->balance - $amount);
                    if (!empty(MAIL_ALERT))
                        $this->msgmodel->insert_comm(MAIL_ALERT, "email", $msg, APP_NAME . ", Low float balance", 'Support', "System");
                    $this->msgmodel->insert_comm("vbnetter@gmail.com", "email", $msg, APP_NAME . ", Low float balance", 'Support', "System");
                }

                if ($partner->isexternal == 1) {
                    //egift  
                    $resp = $this->egift->egift($dmo_id, $amount);
                    $encresp = json_decode($resp);
                    if (!isset($encresp->error)) {

                        $orderno = $encresp->orderId;
                        $v_code = $encresp->cards[0]->fields->number;
                        $expiry = $encresp->cards[0]->fields->expiration;

                        $data = array(
                            'verified' => 1,
                            'record_state' => 0,
                            'voucher_type' => 'Redemption',
                            'dmo_id' => $dmo_id,
                            'CUST_CODE' => '',
                            'voucher_value' => $amount,
                            'addedon' => date('Y-m-d H:i:s'),
                            'verifiedon' => date('Y-m-d H:i:s'),
                            'raw' => $resp,
                            'client_id' => $client_id,
                            'ref_id' => $orderno,
                            'noofpoints' => 0,
                            'expiry' => date('Y-m-d', strtotime($expiry)),
                            'CUST_NAME' => '',
                            'CUST_PHONE' => $phone_no,
                            'voucher_code' => $v_code
                        );
                        $added = $rec = $this->vouchersmodel->insert($data);

                        $this->auditmodel->insert("Egift redemption successfull (Order ID: " . $orderno . ") Voucher Code: " . $v_code  . " expiring on " . $expiry . "  for: " . $partner->name . ". Redeeming kes: " . $amount,  $added, "Redemption API", $resp);
                        if ($rec == 0) {
                            $msg = '<p>Check on saving voucher on core system. Voucher generated but failed to save</p>';
                            $this->msgmodel->insert_comm("vbnetter@gmail.com", "email", $msg, APP_NAME . ", Float alert", 'Support', "System");
                        }
                        $this->response(array('result' => 'ok', 'data' => array('voucher_code' => $v_code, 'expiry' => $expiry, 'ref' => $orderno, 'amount' => $amount)));
                    } else {
                        $this->auditmodel->insert("Error redeeming Egift voucher " . $resp . " redeeming from : " . $partner->name . ". Redeeming kes: " . $amount, 0, "Redemption API", $resp);
                        $this->unauthorized("Failed to redeem. please try again. " . $encresp->error_description);
                    }
                } else {
                    //local partners
                    switch (strtolower($dmo_id)) {
                        case 'zawadi_mall':
                            $voucher = $this->generatevoucher();
                            $curl_post_data = array(
                                "code" => $voucher,
                                "discount_type" => "fixed_cart",
                                "amount" => $amount,
                                "individual_use" => true,
                            ); 

                            $request_uri = 'https://zawadimall.com/wp-json/wc/v3/coupons';  
                            $nonce = uniqid();
                            $timestamp = time(); 
                            $oauth_signature_method = 'HMAC-SHA1'; 
                            $hash_algorithm = strtolower( str_replace( 'HMAC-', '', $oauth_signature_method ) ); // sha1
                            $secret = ZAWADI_KEY . '&';

                            $http_method = 'POST';
                            $base_request_uri = rawurlencode( $request_uri );
                            $params = array( 'oauth_consumer_key' => ZAWADI_KEY, 
                                'oauth_nonce' => $nonce, 
                                'oauth_signature_method' => 'HMAC-SHA1', 
                                'oauth_timestamp' => $timestamp,
                                "code" => $voucher,
                                "discount_type" => "fixed_cart",
                                "amount" => $amount,
                                "individual_use" => true,
                            );
                            $query_string = $this->join_params( $params );

                            $string_to_sign = $http_method . '&' . $base_request_uri . '&' . $query_string;
                            $oauth_signature = base64_encode( hash_hmac( $hash_algorithm, $string_to_sign, $secret, true ) );


                            $data_string = json_encode($curl_post_data);   

                            $curl = curl_init();
                            curl_setopt($curl, CURLOPT_URL,$request_uri);
                            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                                'Content-Type:application/json',
                            ));  
                            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($curl, CURLOPT_HEADER, false);
                            curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
                            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
                            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                            curl_setopt($curl, CURLOPT_POST, true);
                            curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);
                            $jsonstr = curl_exec($curl);
                            echo $jsonstr;
                            echo base64_encode(ZAWADI_KEY  . ":" . ZAWADI_SECRET);
                            break;
                        case 'naivas':
                            $curl_post_data = array(
                                'amount' => $amount,
                                'client_id' =>  $client_id,
                                'phone_no' =>  $phone_no,
                                'dmo_id' =>  $dmo_id,
                                'dmo_no' =>  "N@!v@s @2o3o by mz@w@d!"
                            );
                            $data_string = json_encode($curl_post_data);

                            $curl = curl_init();
                            curl_setopt($curl, CURLOPT_URL, base_url() . "api/redeemAtNaivas_frmeng");
                            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
                            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($curl, CURLOPT_HEADER, false);
                            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                            curl_setopt($curl, CURLOPT_POST, true);
                            curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);
                            $jsonstr = curl_exec($curl);

                            if ($jsonstr === false) {
                                $this->auditmodel->insert("Error redeeming Naivas: " . $jsonstr . " Redeeming kes: " . $amount, 0, "Redemption API", $jsonstr);
                                $this->unauthorized("Failed to redeem. please try again." . $jsonstr);
                                return;
                            }

                            $json = json_decode($jsonstr);

                            if (isset($json->VoucherNo)) {
                                $added = $this->dbmodel->update('vouchers', array('' => $json->NvsId), array('' => $json->TransactionId));
                                $added = $this->db->affected_rows();
                                $this->auditmodel->insert("Naivas redemption successfull (Order ID: " . $json->TransactionId . ") voucher code: " . $json->VoucherNo  . " for: " . $partner->name . ". Redeeming kes: " . $amount,  $added, "Redemption API", $jsonstr);
                                $this->response(array('result' => 'ok', 'data' => array('voucher_code' => $json->VoucherNo, 'expiry' => '', 'ref' => $json->TransactionId, 'customer' => $json->customer, 'amount' => $amount)));
                            } else {
                                $this->auditmodel->insert("Error redeeming Naivas: " . $jsonstr . " Redeeming kes: " . $amount, 0, "Redemption API", $jsonstr);
                                $this->unauthorized("Failed to redeem. please try again." . $json->message);
                            }
                            break;
                        case 'kplc_postpay':
                            $account_no = $this->input->post('account_no');
                            if (empty($account_no)) {
                                $this->auditmodel->insert("Tried to redeem kplc postpay kes: " . $amount . " phone : " . $phone_no . ".  meter " . $account_no . " >> Account no not provided", 0, "Redemption API", $resp);
                                $this->unauthorized("Failed to redeem. Account number is required.");
                            }

                            $jsonstr = $this->vendingpoint->kplc_bill_only($account_no, $amount, $phone_no);
                            $json = json_decode($jsonstr);

                            if ($json->result == "ok") {
                                $added = $this->addtodb("Redemption", $dmo_id, $amount, $json->raw, $client_id, $json->refid, date('Y-m-d', strtotime("+6 months")), $phone_no, $json->rctnum);
                                $this->auditmodel->insert("KPLC postpay redemption successfull (Order ID: " . $json->refid . ") receipt number: " . $json->rctnum  . " for: " . $partner->name . ". Redeeming kes: " . $amount,  $added, "Redemption API", $jsonstr);
                                $this->response(array('result' => 'ok', 'data' => array('receipt_no' => $json->rctnum, 'expiry' => '', 'ref' => $json->refid, 'customer' => $json->customer, 'amount' => $amount)));
                            } else {
                                $this->auditmodel->insert("Error redeeming KPLC postpay: " . $jsonstr . " redeeming from : " . $partner->name . ". Redeeming kes: " . $amount, 0, "Redemption API", $jsonstr);
                                $this->unauthorized("Failed to redeem. please try again." . $json->msg);
                            }
                            break;
                        case 'kplc_tokens':
                            $meter_no = $this->input->post('meter_no');
                            if (empty($meter_no)) {
                                $this->auditmodel->insert("Tried to redeem kplc tokens kes: " . $amount . " phone : " . $phone_no . ".  meter " . $meter_no . " >> Invalid Meter not provided", 0, "Redemption API", $resp);
                                $this->unauthorized("Failed to redeem. Meter number is required.");
                            }

                            $jsonstr = $this->vendingpoint->kplc_bill($meter_no, $amount, $phone_no);
                            $json = json_decode($jsonstr);

                            if ($json->result == "ok") {
                                $added = $this->addtodb("Redemption", $dmo_id, $amount, $json->raw, $client_id, $json->refid, date('Y-m-d', strtotime("+6 months")), $phone_no, $json->refcode);
                                $this->auditmodel->insert("KPLC token redemption successfull (Order ID: " . $json->refid . ") token Code: " . $json->token  . " for: " . $partner->name . ". Redeeming kes: " . $amount,  $added, "Redemption API", $jsonstr);
                                $this->response(array('result' => 'ok', 'data' => array('token_code' => $json->token, 'units' => $json->units, 'expiry' => '', 'ref' => $json->refid, 'customer' => $json->customer, 'amount' => $amount)));
                            } else {
                                $this->auditmodel->insert("Error redeeming KPLC token: " . $jsonstr . " redeeming from : " . $partner->name . ". Redeeming kes: " . $amount, 0, "Redemption API", $jsonstr);
                                $this->unauthorized("Failed to redeem. please try again." . $json->msg);
                            }
                            break;
                        case 'vend_airtime':
                            $operator = $this->input->post('operator');
                            //|Safaricom|safaricom| 
                            if (empty($operator) || (strtolower($operator) != "airtel" && strtolower($operator) != "orange" && strtolower($operator) != "yu" && strtolower($operator) != "safaricom")) {
                                $this->auditmodel->insert("Tried to redeem airtime kes: " . $amount . " phone : " . $phone_no . ".  operator " . $operator . " >> Invalid operator provided", 0, "Redemption API", $resp);
                                $this->unauthorized("Failed to redeem. Invalid operator provided (airtel | safaricom | orange ).");
                            }

                            $jsonstr = $this->vendingpoint->buy_credit($amount, $phone_no, $operator);
                            $json = json_decode($jsonstr);

                            if ($json->result == "ok") {
                                $added = $this->addtodb("Redemption", $dmo_id, $amount, $json->raw, $client_id, $json->refid, date('Y-m-d', strtotime("+6 months")), $phone_no, $json->refcode);
                                $this->auditmodel->insert("Airtime redemption successfull (Order ID: " . $json->refid . ") Voucher Code: " . $json->refcode  . " for: " . $partner->name . ". Redeeming kes: " . $amount,  $added, "Redemption API", $jsonstr);
                                $this->response(array('result' => 'ok', 'data' => array('voucher_code' => $json->refcode, 'expiry' => '', 'ref' => $json->refid, 'amount' => $amount)));
                            } else {
                                $this->auditmodel->insert("Error redeeming Airtime voucher " . $jsonstr . " redeeming from : " . $partner->name . ". Redeeming kes: " . $amount, 0, "Redemption API", $jsonstr);
                                $this->unauthorized("Failed to redeem. please try again." . $json->msg);
                            }
                            break;
                        default:
                            $this->unauthorized("Failed to redeem. please try again.");
                            break;
                    }
                }
            }
        } else {
            $this->auditmodel->insert("Tried to redeem and failed invalid client id provided.", 0, "Redemption API", json_encode($this->input->post()));
            $this->unauthorized("Invalid Token");
        }
    }


    function join_params($params)
    {
        $query_params = array();

        foreach ($params as $param_key => $param_value) {
            $string = $param_key . '=' . $param_value;
            $query_params[] = str_replace(array('+', '%7E'), array(' ', '~'), rawurlencode($string));
        } 
        return implode('%26', $query_params);
    }

    private function addtodb($type, $dmo_id, $amount, $raw, $client_id, $refid, $expiry, $phone_no, $refcode)
    {
        $data = array(
            'verified' => 1,
            'record_state' => 0,
            'voucher_type' => $type,
            'dmo_id' => $dmo_id,
            'CUST_CODE' => '',
            'voucher_value' => $amount,
            'addedon' => date('Y-m-d H:i:s'),
            'verifiedon' => date('Y-m-d H:i:s'),
            'raw' => $raw,
            'client_id' => $client_id,
            'ref_id' => $refid,
            'noofpoints' => 0,
            'expiry' => $expiry,
            'CUST_NAME' => '',
            'CUST_PHONE' => $phone_no,
            'voucher_code' => $refcode
        );
        $added =  $this->vouchersmodel->insert($data);

        if ($added == 0) {
            $msg = '<p>Check on saving voucher on core system. Voucher generated but failed to save</p>';
            $this->msgmodel->insert_comm("vbnetter@gmail.com", "email", $msg, APP_NAME . ", Float alert", 'Support', "System");
        }
        return $added;
    }

    private function generatevoucher()
    {
        $word = "";
        $pick = '123456789';
        $length = 9;
        while (strlen($word) < $length) {
            $word .= substr($pick, mt_rand() % (strlen($pick)), 1);
        }
        $word = str_shuffle($word) . str_shuffle($word) . str_shuffle($word) . str_shuffle($word) . str_shuffle($word) . str_shuffle($word);

        $word = substr(str_shuffle($word), 0, $length);
        $vouchers = $this->vouchersmodel->get(array('record_state' => 0, 'voucher_code' => $word));
        if ($vouchers->num_rows() > 0)
            $this->generatevoucher();
        return $word;
    }

    private function generaterefid()
    {
        $code = random_string('alnum', 7) . date("YmdHis");
        return strtoupper($code);
    }
}
