<?php
class Home extends CI_Controller{

	public function __construct()
	{
		parent::__construct();
		$this->load->library('captcha');
		$this->load->model('captchamodel');
		$this->load->model('msgmodel');
		$this->load->model('dbmodel');
	}

	public function index(){
		$this->load->view("website/header");
		$this->load->view('website/index');
		$this->load->view("website/footer");
	}

	public function pay($rec){
		$rec = trim(base64_decode(urldecode($rec)));  
		$clients = $this->dbmodel->get('customers', array('id'=>$rec)) ->row(); 
		$bal = $this->dbmodel->get('client_float_balance', array('id'=>$rec))->row();
 
		$data['amount'] = $bal->balance; 
		$data['name'] = $clients->name; 
		$data['phone'] = $clients->contact_phone; 
		$data['cid'] = $rec;

		$this->load->view("website/header");
		$this->load->view('website/pay',$data);
		$this->load->view("website/footer");
	}

	public function reset_password(){
		$this->load->view("website/header");
		$this->load->view('website/reset');
		$this->load->view("website/footer");
	}

	public function privacy_policy(){
		//$this->load->view('home/header.php');
        $this->load->view('website/privacy_policy.php' );
        //$this->load->view('home/footer.php');
	}

	public function terms(){
		echo "<h1>Terms &amp; Conditions</h1>";
	}

	function getCaptcha(){
		$vals = array(
		   'img_path'	=>  dirname(dirname(dirname(__FILE__))).'/captcha/',
		   'img_url'	=>  base_url() .'captcha/',
		);
	   $cap = $this->captcha->create_captcha($vals);
		$this->captchamodel->insert($cap['word'],$cap['time'],"login");
	   header("Content-type: image/png");
	   echo file_get_contents(dirname(dirname(dirname(__FILE__))).'/captcha/'.$cap['filename']);
   }
   
}
?>